//**---------------------LEDs & Taster---------------------**//			

#define Direction_LED_and_Switches() DDRD |= 0xE3; 			//PD6,PD7 als Ausgänge für LED; Rest als Eingänge für Taster
#define Direction_VFD_Tube_Digit() DDRC |= 0xFF;
#define Direction_VFD_Tube_Segment() DDRA |= 0xFF;
#define Pullups() PORTD |= 0x1C; 							// Pullups aktivieren

//LEDs
#define LED1_ON()  PORTD|=_BV(PD5)			
#define LED1_OFF() PORTD&=~_BV(PD5)	
#define LED1_STATUS_ON (bit_is_set(PIND, PD5))
#define LED1_STATUS_OFF (!bit_is_set(PIND, PD5))					
#define LED2_ON()  PORTD|=_BV(PD6)			
#define LED2_OFF() PORTD&=~_BV(PD6)
#define LED2_STATUS_ON (bit_is_set(PIND, PD6))
#define LED2_STATUS_OFF (!bit_is_set(PIND, PD6))	
#define TOGGLE_TUBE_LIGHT() PORTD^=_BV(PD7)	
#define TUBE_LIGHT_ON()		PORTD|=_BV(PD7)
#define TUBE_LIGHT_OFF()	PORTD&=_BV(PD7)	

//Taster
#define TAST_1 	(PIND&(1<<PIND2) 		&& !(PIND&(1<<PIND3)) 	&& !(PIND&(1<<PIND4)))	//100					
#define TAST_6 	(!(PIND&(1<<PIND2)) 	&& PIND&(1<<PIND3) 		&& PIND&(1<<PIND4))		//011
#define TAST_3 	(PIND&(1<<PIND2) 		&& PIND&(1<<PIND3) 		&& !(PIND&(1<<PIND4)))	//110
#define TAST_4  (!(PIND&(1<<PIND2)) 	&& !(PIND&(1<<PIND3)) 	&& PIND&(1<<PIND4))		//001
#define TAST_5 	(PIND&(1<<PIND2) 		&& !(PIND&(1<<PIND3)) 	&& PIND&(1<<PIND4))		//101
#define TAST_2 	(!(PIND&(1<<PIND2)) 	&& PIND&(1<<PIND3) 		&& !(PIND&(1<<PIND4)))	//010
#define TAST_7 	(!(PIND&(1<<PIND2)) 	&& !(PIND&(1<<PIND3)) 	&& !(PIND&(1<<PIND4)))	//000
#define PRESSED (!(PIND&(1<<PIND2)) 	||!(PIND&(1<<PIND3))	|| !(PIND&(1<<PIND4)))

//**------------------------SD Card------------------------**//	
#define MMC_SD_PORT       PORTB                    				
#define MMC_SD_CS_PIN     4     					
#define DDR_INI() DDRB |= _BV(4)|_BV(5)|_BV(7)  		


//**------------------------VS 1003B------------------------**//	
#define DefaultVolume   0x2828			
#define CLOCK_REG       0xc000          //0xc00 für VS1003 oder höher			
//#define CLOCK_REG       0x9800        //0x9800 für VS1011 VS1002					

#define VS1003B_PORT    PORTB			
#define VS1003B_DDR      DDRB			
#define VS1003B_PIN      PINB			

#define VS1003B_XCS     3				
#define VS1003B_XRESET  0				
#define VS1003B_DREQ    1				
#define VS1003B_XDCS    2				


//**------------------------ Filesystem ------------------------**//
#define FIX_DIRECTORY 0		// 0 = Jedes / 1 = Festes Verzeichniss

#if FIX_DIRECTORY
#define PATH (unsigned char *)("\\music")
#endif
// Verzeichniss für die Musik auf der SD-Karte
// der Pfad sollte keine Leer- oder Sonderzeichen haben

#define MP3 1
#define WMA 2
#define MID 3

// Play-Modus
#define REPET_ALL 0
#define REPET_ONE 1
#define RANDOM    2
#define DEFAULT_MODE   2
